<?php
/**
 * The template to display Admin notices
 *
 * @package VETO
 * @since VETO 1.0.64
 */

$veto_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$veto_skins_args = get_query_var( 'veto_skins_notice_args' );
?>
<div class="veto_admin_notice veto_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$veto_theme_img = veto_get_file_url( 'screenshot.jpg' );
	if ( '' != $veto_theme_img ) {
		?>
		<div class="veto_notice_image"><img src="<?php echo esc_url( $veto_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'veto' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="veto_notice_title">
		<?php esc_html_e( 'New skins are available', 'veto' ); ?>
	</h3>
	<?php

	// Description
	$veto_total      = $veto_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$veto_skins_msg  = $veto_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $veto_total, 'veto' ), $veto_total ) . '</strong>'
							: '';
	$veto_total      = $veto_skins_args['free'];
	$veto_skins_msg .= $veto_total > 0
							? ( ! empty( $veto_skins_msg ) ? ' ' . esc_html__( 'and', 'veto' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $veto_total, 'veto' ), $veto_total ) . '</strong>'
							: '';
	$veto_total      = $veto_skins_args['pay'];
	$veto_skins_msg .= $veto_skins_args['pay'] > 0
							? ( ! empty( $veto_skins_msg ) ? ' ' . esc_html__( 'and', 'veto' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $veto_total, 'veto' ), $veto_total ) . '</strong>'
							: '';
	?>
	<div class="veto_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'veto' ), $veto_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="veto_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $veto_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'veto' );
			?>
		</a>
	</div>
</div>
