<?php
/**
 * The template to display default site header
 *
 * @package VETO
 * @since VETO 1.0
 */

$veto_header_css   = '';
$veto_header_image = get_header_image();
$veto_header_video = veto_get_header_video();
if ( ! empty( $veto_header_image ) && veto_trx_addons_featured_image_override( veto_is_singular() || veto_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$veto_header_image = veto_get_current_mode_image( $veto_header_image );
}
?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $veto_header_image ) || ! empty( $veto_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $veto_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $veto_header_image ) {
		echo ' ' . esc_attr( veto_add_inline_css_class( 'background-image: url(' . esc_url( $veto_header_image ) . ');' ) );
	}
	if ( veto_is_singular() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $veto_header_video ) ) {
		get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/header-navi' ) );

	// Page title and breadcrumbs area
	if ( ! veto_is_single() ) {
		get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/header-title' ) );
	}
	?>
</header>
