<?php
/**
 * The template to display default site footer
 *
 * @package VETO
 * @since VETO 1.0.10
 */

$veto_footer_id = veto_get_custom_footer_id();
$veto_footer_meta = veto_get_custom_layout_meta( $veto_footer_id );
if ( ! empty( $veto_footer_meta['margin'] ) ) {
	veto_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( veto_prepare_css_value( $veto_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $veto_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $veto_footer_id ) ) ); ?>">
	<?php
	// Custom footer's layout
	do_action( 'veto_action_show_layout', $veto_footer_id );
	?>
</footer>