<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package VETO
 * @since VETO 1.0
 */

$veto_template_args = get_query_var( 'veto_template_args' );

if ( is_array( $veto_template_args ) ) {
	$veto_columns       = empty( $veto_template_args['columns'] ) ? 1 : max( 1, $veto_template_args['columns'] );
	$veto_blog_style    = array( $veto_template_args['type'], $veto_columns );
	$veto_columns_class = veto_get_column_class( 1, $veto_columns, ! empty( $veto_template_args['columns_tablet']) ? $veto_template_args['columns_tablet'] : '', ! empty($veto_template_args['columns_mobile']) ? $veto_template_args['columns_mobile'] : '' );
} else {
	$veto_template_args = array();
	$veto_blog_style    = explode( '_', veto_get_theme_option( 'blog_style' ) );
	$veto_columns       = empty( $veto_blog_style[1] ) ? 1 : max( 1, $veto_blog_style[1] );
	$veto_columns_class = veto_get_column_class( 1, $veto_columns );
}
$veto_expanded   = ! veto_sidebar_present() && veto_get_theme_option( 'expand_content' ) == 'expand';

$veto_post_format = get_post_format();
$veto_post_format = empty( $veto_post_format ) ? 'standard' : str_replace( 'post-format-', '', $veto_post_format );

?><div class="<?php
	if ( ! empty( $veto_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( veto_is_blog_style_use_masonry( $veto_blog_style[0] )
			? 'masonry_item masonry_item-1_' . esc_attr( $veto_columns )
			: esc_attr( $veto_columns_class )
			);
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $veto_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $veto_columns )
				. ' post_layout_' . esc_attr( $veto_blog_style[0] )
				. ' post_layout_' . esc_attr( $veto_blog_style[0] ) . '_' . esc_attr( $veto_columns )
	);
	veto_add_blog_animation( $veto_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$veto_hover      = ! empty( $veto_template_args['hover'] ) && ! veto_is_inherit( $veto_template_args['hover'] )
							? $veto_template_args['hover']
							: veto_get_theme_option( 'image_hover' );

	$veto_components = ! empty( $veto_template_args['meta_parts'] )
							? ( is_array( $veto_template_args['meta_parts'] )
								? $veto_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $veto_template_args['meta_parts'] ) )
								)
							: veto_array_get_keys_by_value( veto_get_theme_option( 'meta_parts' ) );

	veto_show_post_featured( apply_filters( 'veto_filter_args_featured',
		array(
			'thumb_size' => ! empty( $veto_template_args['thumb_size'] )
								? $veto_template_args['thumb_size']
								: veto_get_thumb_size(
									strpos( veto_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( $veto_columns > 2 ? 'big' : 'full' )
										: ( $veto_columns > 2
											? 'med'
											: ( $veto_expanded || $veto_columns == 1 ? 
												( $veto_expanded && $veto_columns == 1 ? 'huge' : 'big' ) 
												: 'med' 
												)
											)												
								),
			'hover'      => $veto_hover,
			'meta_parts' => $veto_components,
			'no_links'   => ! empty( $veto_template_args['no_links'] ),
		),
		'content-classic',
		$veto_template_args
	) );

	// Title and post meta
	$veto_show_title = get_the_title() != '';
	$veto_show_meta  = count( $veto_components ) > 0;

	if ( $veto_show_title ) {
		?><div class="post_header entry-header"><?php
			// Categories
			if ( apply_filters( 'veto_filter_show_blog_categories', $veto_show_meta && in_array( 'categories', $veto_components ), array( 'categories' ), 'classic' ) ) {
				do_action( 'veto_action_before_post_category' );
				?><div class="post_category"><?php
					veto_show_post_meta( apply_filters(
														'veto_filter_post_meta_args',
														array(
															'components' => 'categories',
															'seo'        => false,
															'echo'       => true,
															),
														'hover_' . $veto_hover, 1
														)
										);
				?></div><?php
				$veto_components = veto_array_delete_by_value( $veto_components, 'categories' );
				do_action( 'veto_action_after_post_category' );
			}
			// Post title
			if ( apply_filters( 'veto_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'veto_action_before_post_title' );
				if ( empty( $veto_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'veto_action_after_post_title' );
			}
		?></div><?php
	}
	
	// Post meta
	if ( apply_filters( 'veto_filter_show_blog_meta', $veto_show_meta, $veto_components, 'classic' ) ) {
		if ( count( $veto_components ) > 0 ) {
			do_action( 'veto_action_before_post_meta' );
			veto_show_post_meta(
				apply_filters(
					'veto_filter_post_meta_args', array(
						'components' => join( ',', $veto_components ),
						'seo'        => false,
						'echo'       => true,
						'author_avatar' => false,
					), $veto_blog_style[0], $veto_columns
				)
			);
			do_action( 'veto_action_after_post_meta' );
		}
	}

	// Post content
	ob_start();
	if ( apply_filters( 'veto_filter_show_blog_excerpt', ( ! isset( $veto_template_args['hide_excerpt'] ) || (int)$veto_template_args['hide_excerpt'] == 0 ) && (int)veto_get_theme_option( 'excerpt_length' ) > 0, 'classic' ) ) {
		veto_show_post_content( $veto_template_args, '<div class="post_content_inner">', '</div>' );
	}
	$veto_content = ob_get_contents();
	ob_end_clean();

	veto_show_layout( $veto_content, '<div class="post_content entry-content">', '</div>' );

		
	// More button
	if ( apply_filters( 'veto_filter_show_blog_readmore', ! $veto_show_title || ! empty( $veto_template_args['more_button'] ), 'classic' ) ) {
		if ( empty( $veto_template_args['no_links'] ) ) {
			do_action( 'veto_action_before_post_readmore' );
			veto_show_post_more_link( $veto_template_args, '<p>', '</p>' );
			do_action( 'veto_action_after_post_readmore' );
		}
	}

	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
