<?php
/**
 * The template to display Admin notices
 *
 * @package VETO
 * @since VETO 1.0.1
 */

$veto_theme_slug = get_template();
$veto_theme_obj  = wp_get_theme( $veto_theme_slug );

?>
<div class="veto_admin_notice veto_rate_notice notice notice-info is-dismissible" data-notice="rate">
	<?php
	// Theme image
	$veto_theme_img = veto_get_file_url( 'screenshot.jpg' );
	if ( '' != $veto_theme_img ) {
		?>
		<div class="veto_notice_image"><img src="<?php echo esc_url( $veto_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'veto' ); ?>"></div>
		<?php
	}

	// Title
	$veto_theme_name = '"' . $veto_theme_obj->get( 'Name' ) . ( VETO_THEME_FREE ? ' ' . __( 'Free', 'veto' ) : '' ) . '"';
	?>
	<h3 class="veto_notice_title"><a href="<?php echo esc_url( veto_storage_get( 'theme_rate_url' ) ); ?>" target="_blank">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name to the 'Welcome' message
				__( 'Help Us Grow - Rate %s Today!', 'veto' ),
				$veto_theme_name
			)
		);
		?>
	</a></h3>
	<?php

	// Description
	?>
	<div class="veto_notice_text">
		<p><?php
			// Translators: Add theme name to the 'Welcome' message
			echo wp_kses_data( sprintf( __( "Thank you for choosing the %s theme for your website! We're excited to see how you've customized your site, and we hope you've enjoyed working with our theme.", 'veto' ), $veto_theme_name ) );
		?></p>
		<p><?php
			// Translators: Add theme name to the 'Welcome' message
			echo wp_kses_data( sprintf( __( "Your feedback really matters to us! If you've had a positive experience, we'd love for you to take a moment to rate %s and share your thoughts on the customer service you received.", 'veto' ), $veto_theme_name ) );
		?></p>
	</div>
	<?php

	// Buttons
	?>
	<div class="veto_notice_buttons">
		<?php
		// Link to the theme download page
		?>
		<a href="<?php echo esc_url( veto_storage_get( 'theme_rate_url' ) ); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> 
			<?php
			// Translators: Add the theme name to the button caption
			echo esc_html( sprintf( __( 'Rate %s Now', 'veto' ), $veto_theme_name ) );
			?>
		</a>
		<?php
		// Link to the theme support
		?>
		<a href="<?php echo esc_url( veto_storage_get( 'theme_support_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> 
			<?php
			esc_html_e( 'Support', 'veto' );
			?>
		</a>
		<?php
		// Link to the theme documentation
		?>
		<a href="<?php echo esc_url( veto_storage_get( 'theme_doc_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> 
			<?php
			esc_html_e( 'Documentation', 'veto' );
			?>
		</a>
	</div>
</div>
