<?php
/**
 * Required plugins
 *
 * @package VETO
 * @since VETO 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'veto_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'veto_skin_required_plugins', -1 );
	function veto_skin_required_plugins() {
		$veto_theme_required_plugins_groups = array(
			'core'          => esc_html__( 'Core', 'veto' ),
			'page_builders' => esc_html__( 'Page Builders', 'veto' ),
			'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'veto' ),
			'socials'       => esc_html__( 'Socials and Communities', 'veto' ),
			'events'        => esc_html__( 'Events and Appointments', 'veto' ),
			'content'       => esc_html__( 'Content', 'veto' ),
			'other'         => esc_html__( 'Other', 'veto' ),
		);
		$veto_theme_required_plugins        = array(
			// Core
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'veto' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'veto' ),
				'required'    => true, // Check this plugin in the list on load Theme Dashboard
				'logo'        => 'trx_addons.png',
				'group'       => $veto_theme_required_plugins_groups['core'],
			),
			// Page Builders
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'veto' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'veto' ),
				'required'    => false, // Leave this plugin unchecked on load Theme Dashboard
				'logo'        => 'elementor.png',
				'group'       => $veto_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'veto' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'veto' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $veto_theme_required_plugins_groups['page_builders'],
			),
			// E-Commerce & Donations
			'give'                       => array(
				'title'       => esc_html__( 'Give', 'veto' ),
				'description' => '',
				'required'    => false,
				'install'     => true,
				'logo'        => 'give.png',
				'group'       => $veto_theme_required_plugins_groups['ecommerce'],
			),
			// Content
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'veto' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'veto' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $veto_theme_required_plugins_groups['content'],
			),
			'metform'                    => array(
				'title'       => esc_html__( 'MetForm', 'veto' ),
				'description' => esc_html__( "Contact Form, Survey, Quiz, & Custom Form Builder for Elementor", 'veto' ),
				'required'    => false,
				'logo'        => 'metform.png',
				'group'       => $veto_theme_required_plugins_groups['content'],
			),
			// Other
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'veto' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'veto' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $veto_theme_required_plugins_groups['other'],
			)
		);

		if ( VETO_THEME_FREE ) {
			unset( $veto_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $veto_theme_required_plugins['trx_updater'] );
		}

		// Add plugins list to the global storage
		veto_storage_set( 'required_plugins', $veto_theme_required_plugins );
	}
}
