<?php
/**
 * The template to display single post
 *
 * @package VETO
 * @since VETO 1.0
 */

// Full post loading
$full_post_loading          = veto_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = veto_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = veto_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$veto_related_position   = veto_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$veto_posts_navigation   = veto_get_theme_option( 'posts_navigation' );
$veto_prev_post          = false;
$veto_prev_post_same_cat = (int)veto_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( veto_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	veto_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'veto_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $veto_posts_navigation ) {
		$veto_prev_post = get_previous_post( $veto_prev_post_same_cat );  // Get post from same category
		if ( ! $veto_prev_post && $veto_prev_post_same_cat ) {
			$veto_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $veto_prev_post ) {
			$veto_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $veto_prev_post ) ) {
		veto_sc_layouts_showed( 'featured', false );
		veto_sc_layouts_showed( 'title', false );
		veto_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $veto_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/content', 'single-' . veto_get_theme_option( 'single_style' ) ), 'single-' . veto_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $veto_related_position, 'inside' ) === 0 ) {
		$veto_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'veto_action_related_posts' );
		$veto_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $veto_related_content ) ) {
			$veto_related_position_inside = max( 0, min( 9, veto_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $veto_related_position_inside ) {
				$veto_related_position_inside = mt_rand( 1, 9 );
			}

			$veto_p_number         = 0;
			$veto_related_inserted = false;
			$veto_in_block         = false;
			$veto_content_start    = strpos( $veto_content, '<div class="post_content' );
			$veto_content_end      = strrpos( $veto_content, '</div>' );

			for ( $i = max( 0, $veto_content_start ); $i < min( strlen( $veto_content ) - 3, $veto_content_end ); $i++ ) {
				if ( $veto_content[ $i ] != '<' ) {
					continue;
				}
				if ( $veto_in_block ) {
					if ( strtolower( substr( $veto_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$veto_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $veto_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $veto_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$veto_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $veto_content[ $i + 1 ] && in_array( $veto_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$veto_p_number++;
					if ( $veto_related_position_inside == $veto_p_number ) {
						$veto_related_inserted = true;
						$veto_content = ( $i > 0 ? substr( $veto_content, 0, $i ) : '' )
											. $veto_related_content
											. substr( $veto_content, $i );
					}
				}
			}
			if ( ! $veto_related_inserted ) {
				if ( $veto_content_end > 0 ) {
					$veto_content = substr( $veto_content, 0, $veto_content_end ) . $veto_related_content . substr( $veto_content, $veto_content_end );
				} else {
					$veto_content .= $veto_related_content;
				}
			}
		}

		veto_show_layout( $veto_content );
	}

	// Comments
	do_action( 'veto_action_before_comments' );
	comments_template();
	do_action( 'veto_action_after_comments' );

	// Related posts
	if ( 'below_content' == $veto_related_position
		&& ( 'scroll' != $veto_posts_navigation || (int)veto_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)veto_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'veto_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $veto_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $veto_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $veto_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $veto_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'veto_action_nav_links_single_scroll_data', $veto_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
