<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package VETO
 * @since VETO 1.0
 */

if ( veto_sidebar_present() ) {
	
	$veto_sidebar_type = veto_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $veto_sidebar_type && ! veto_is_layouts_available() ) {
		$veto_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $veto_sidebar_type ) {
		// Default sidebar with widgets
		$veto_sidebar_name = veto_get_theme_option( 'sidebar_widgets' );
		veto_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $veto_sidebar_name ) ) {
			dynamic_sidebar( $veto_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$veto_sidebar_id = veto_get_custom_sidebar_id();
		do_action( 'veto_action_show_layout', $veto_sidebar_id );
	}
	$veto_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $veto_out ) ) {
		$veto_sidebar_position    = veto_get_theme_option( 'sidebar_position' );
		$veto_sidebar_position_ss = veto_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $veto_sidebar_position );
			echo ' sidebar_' . esc_attr( $veto_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $veto_sidebar_type );

			$veto_sidebar_scheme = apply_filters( 'veto_filter_sidebar_scheme', veto_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $veto_sidebar_scheme ) && ! veto_is_inherit( $veto_sidebar_scheme ) && 'custom' != $veto_sidebar_type ) {
				echo ' scheme_' . esc_attr( $veto_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="veto_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'veto_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $veto_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$veto_title = apply_filters( 'veto_filter_sidebar_control_title', 'float' == $veto_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'veto' ) : '' );
				$veto_text  = apply_filters( 'veto_filter_sidebar_control_text', 'above' == $veto_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'veto' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $veto_title ); ?>"><?php echo esc_html( $veto_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'veto_action_before_sidebar', 'sidebar' );
				veto_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $veto_out ) );
				do_action( 'veto_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'veto_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
