<?php
/**
 * The Header: Logo and main menu
 *
 * @package VETO
 * @since VETO 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( veto_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'veto_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'veto_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('veto_action_body_wrap_attributes'); ?>>

		<?php do_action( 'veto_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'veto_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('veto_action_page_wrap_attributes'); ?>>

			<?php do_action( 'veto_action_page_wrap_start' ); ?>

			<?php
			$veto_full_post_loading = ( veto_is_singular( 'post' ) || veto_is_singular( 'attachment' ) ) && veto_get_value_gp( 'action' ) == 'full_post_loading';
			$veto_prev_post_loading = ( veto_is_singular( 'post' ) || veto_is_singular( 'attachment' ) ) && veto_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $veto_full_post_loading && ! $veto_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="veto_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'veto_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'veto' ); ?></a>
				<?php if ( veto_sidebar_present() ) { ?>
				<a class="veto_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'veto_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'veto' ); ?></a>
				<?php } ?>
				<a class="veto_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'veto_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'veto' ); ?></a>

				<?php
				do_action( 'veto_action_before_header' );

				// Header
				$veto_header_type = veto_get_theme_option( 'header_type' );
				if ( 'custom' == $veto_header_type && ! veto_is_layouts_available() ) {
					$veto_header_type = 'default';
				}
				get_template_part( apply_filters( 'veto_filter_get_template_part', "templates/header-" . sanitize_file_name( $veto_header_type ) ) );

				// Side menu
				if ( in_array( veto_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'veto_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'veto_action_after_header' );

			}
			?>

			<?php do_action( 'veto_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( veto_is_off( veto_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $veto_header_type ) ) {
						$veto_header_type = veto_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $veto_header_type && veto_is_layouts_available() ) {
						$veto_header_id = veto_get_custom_header_id();
						if ( $veto_header_id > 0 ) {
							$veto_header_meta = veto_get_custom_layout_meta( $veto_header_id );
							if ( ! empty( $veto_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$veto_footer_type = veto_get_theme_option( 'footer_type' );
					if ( 'custom' == $veto_footer_type && veto_is_layouts_available() ) {
						$veto_footer_id = veto_get_custom_footer_id();
						if ( $veto_footer_id ) {
							$veto_footer_meta = veto_get_custom_layout_meta( $veto_footer_id );
							if ( ! empty( $veto_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'veto_action_page_content_wrap_class', $veto_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'veto_filter_is_prev_post_loading', $veto_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( veto_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'veto_action_page_content_wrap_data', $veto_prev_post_loading );
			?>>
				<?php
				do_action( 'veto_action_page_content_wrap', $veto_full_post_loading || $veto_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'veto_filter_single_post_header', veto_is_singular( 'post' ) || veto_is_singular( 'attachment' ) ) ) {
					if ( $veto_prev_post_loading ) {
						if ( veto_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'veto_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$veto_path = apply_filters( 'veto_filter_get_template_part', 'templates/single-styles/' . veto_get_theme_option( 'single_style' ) );
					if ( veto_get_file_dir( $veto_path . '.php' ) != '' ) {
						get_template_part( $veto_path );
					}
				}

				// Widgets area above page
				$veto_body_style   = veto_get_theme_option( 'body_style' );
				$veto_widgets_name = veto_get_theme_option( 'widgets_above_page', 'hide' );
				$veto_show_widgets = ! veto_is_off( $veto_widgets_name ) && is_active_sidebar( $veto_widgets_name );
				if ( $veto_show_widgets ) {
					if ( 'fullscreen' != $veto_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					veto_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $veto_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'veto_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $veto_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'veto_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'veto_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="veto_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( veto_is_singular( 'post' ) || veto_is_singular( 'attachment' ) )
							&& $veto_prev_post_loading 
							&& veto_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'veto_action_between_posts' );
						}

						// Widgets area above content
						veto_create_widgets_area( 'widgets_above_content' );

						do_action( 'veto_action_page_content_start_text' );
