<?php
$veto_slider_sc = veto_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $veto_slider_sc ) && strpos( $veto_slider_sc, '[' ) !== false && strpos( $veto_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( veto_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$veto_anchor_icon = veto_get_theme_option( 'front_page_title_anchor_icon' );
		$veto_anchor_text = veto_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $veto_anchor_icon ) || ! empty( $veto_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $veto_anchor_icon ) ? ' icon="' . esc_attr( $veto_anchor_icon ) . '"' : '' )
									. ( ! empty( $veto_anchor_text ) ? ' title="' . esc_attr( $veto_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $veto_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$veto_scheme = veto_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $veto_scheme ) && ! veto_is_inherit( $veto_scheme ) ) {
			echo ' scheme_' . esc_attr( $veto_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( veto_get_theme_option( 'front_page_title_paddings' ) );
		if ( veto_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$veto_css      = '';
		$veto_bg_image = veto_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $veto_bg_image ) ) {
			$veto_css .= 'background-image: url(' . esc_url( veto_get_attachment_url( $veto_bg_image ) ) . ');';
		}
		if ( ! empty( $veto_css ) ) {
			echo ' style="' . esc_attr( $veto_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$veto_anchor_icon = veto_get_theme_option( 'front_page_title_anchor_icon' );
		$veto_anchor_text = veto_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $veto_anchor_icon ) || ! empty( $veto_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $veto_anchor_icon ) ? ' icon="' . esc_attr( $veto_anchor_icon ) . '"' : '' )
									. ( ! empty( $veto_anchor_text ) ? ' title="' . esc_attr( $veto_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( veto_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' veto-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$veto_css      = '';
			$veto_bg_mask  = veto_get_theme_option( 'front_page_title_bg_mask' );
			$veto_bg_color_type = veto_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $veto_bg_color_type ) {
				$veto_bg_color = veto_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $veto_bg_color_type ) {
				$veto_bg_color = veto_get_scheme_color( 'bg_color', $veto_scheme );
			} else {
				$veto_bg_color = '';
			}
			if ( ! empty( $veto_bg_color ) && $veto_bg_mask > 0 ) {
				$veto_css .= 'background-color: ' . esc_attr(
					1 == $veto_bg_mask ? $veto_bg_color : veto_hex2rgba( $veto_bg_color, $veto_bg_mask )
				) . ';';
			}
			if ( ! empty( $veto_css ) ) {
				echo ' style="' . esc_attr( $veto_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$veto_caption = veto_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $veto_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $veto_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $veto_caption, 'veto_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$veto_description = veto_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $veto_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $veto_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $veto_description ), 'veto_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( veto_get_theme_option( 'front_page_title_button1_link' ) != '' || veto_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						veto_show_layout( veto_customizer_partial_refresh_front_page_title_button1_link() );
						veto_show_layout( veto_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
