<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package VETO
 * @since VETO 1.0
 */

							do_action( 'veto_action_page_content_end_text' );
							
							// Widgets area below the content
							veto_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'veto_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'veto_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'veto_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'veto_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$veto_body_style = veto_get_theme_option( 'body_style' );
					$veto_widgets_name = veto_get_theme_option( 'widgets_below_page', 'hide' );
					$veto_show_widgets = ! veto_is_off( $veto_widgets_name ) && is_active_sidebar( $veto_widgets_name );
					$veto_show_related = veto_is_single() && veto_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $veto_show_widgets || $veto_show_related ) {
						if ( 'fullscreen' != $veto_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $veto_show_related ) {
							do_action( 'veto_action_related_posts' );
						}

						// Widgets area below page content
						if ( $veto_show_widgets ) {
							veto_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $veto_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'veto_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'veto_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! veto_is_singular( 'post' ) && ! veto_is_singular( 'attachment' ) ) || ! in_array ( veto_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="veto_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'veto_action_before_footer' );

				// Footer
				$veto_footer_type = veto_get_theme_option( 'footer_type' );
				if ( 'custom' == $veto_footer_type && ! veto_is_layouts_available() ) {
					$veto_footer_type = 'default';
				}
				get_template_part( apply_filters( 'veto_filter_get_template_part', "templates/footer-" . sanitize_file_name( $veto_footer_type ) ) );

				do_action( 'veto_action_after_footer' );

			}
			?>

			<?php do_action( 'veto_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'veto_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'veto_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>